/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;

public class PageBreakFeature
implements MarkdownFeature {
    public String name() {
        return "book_page_breaks";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof BookCompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.expect(-1, '\n') || !nibbler.expect(-2, '\n')) {
                return false;
            }
            if (!nibbler.tryConsume(";;;;;\n\n")) {
                return false;
            }
            tokens.add(new PageBreakToken());
            return true;
        }, ';');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, trigger, tokens) -> new PageBreakNode(), (token, tokenListNibbler) -> {
            PageBreakToken pageBreak;
            return token instanceof PageBreakToken ? (pageBreak = (PageBreakToken)((Object)token)) : null;
        });
    }

    private static class PageBreakToken
    extends Lexer.Token {
        public PageBreakToken() {
            super(";;;;;\n\n");
        }

        public boolean isBoundary() {
            return true;
        }
    }

    private static class PageBreakNode
    extends Parser.Node {
        private PageBreakNode() {
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((BookCompiler)compiler).visitPageBreak();
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

